//-----Device Descriptor-----//
code BYTE DEVICE_DESCRIPTOR[]=
  { 0x12,                                        // 0:  bLength
    0x01,                                        // 1:  bDescriptorType (Device)
    0x10,                                        // 2:  bcdUSB(LSB)
    0x01,                                        //     bcdUSB(MSB)
    0x02,                                        // 4:  bDeviceClass
    0x00,                                        // 5:  bDevice SubClass
    0x00,                                        // 6:  bDeviceProtocol
    0x08,                                        // 7:  bMaxPacketSize
    LOBYTE( USB_VID ),                           // 8:  idVendor(LSB)
    HIBYTE( USB_VID ),                           //     idVendor(MSB)
    LOBYTE( USB_PID ),                           // 10: idProduct(LSB)
    HIBYTE( USB_PID ),                           //     idProduct(MSB)
    LOBYTE( USB_DID ),                           // 12: bcdDevice(LSB)
    HIBYTE( USB_DID ),                           //     bcdDevice(MSB)
#ifdef MF_STRING
    0x01,                                        // 14: iManufacture (String Index)
#endif
#ifndef MF_STRING
    0x00,                                        // 14: iManufacture (String Index)
#endif
#ifdef PD_STRING
    0x02,                                        // 15: iProduct     (String Index)
#endif
#ifndef PD_STRING
    0x00,                                        // 15: iProduct     (String Index)
#endif
#ifdef SN_STRING    
    0x03,                                        // 16: iSerialNumber(String Index)
#endif
#ifndef SN_STRING    
    0x00,                                        // 16: iSerialNumber(String Index)
#endif
    0x01                                         // 17: bNumConfigurations
  };


code BYTE LANGUAGEID_DESCRIPTOR[]=
  { 0x04,					 // Computed by subtraction two from the value of the first byte of the descriptor
    0x03, 					 // Descriptor Type
    0x09,
    0x04
  };


#define MFS_LEN sizeof("Megawin Technology Inc.")*2
//-----MANUFACTURER(UNICODE) in String Descriptor-----//
code BYTE MANUFACTURER_DESCRIPTOR[]=
  { MFS_LEN,
    0x03,                                        // Descriptor Type
    'M',0x00,
    'e',0x00,
    'g',0x00,
    'a',0x00,
    'w',0x00,
    'i',0x00,
    'n',0x00,
    ' ',0x00,
    'T',0x00,
    'e',0x00,
    'c',0x00,
    'h',0x00,
    'n',0x00,
    'o',0x00,
    'l',0x00,
    'o',0x00,
    'g',0x00,
    'y',0x00,
    ' ',0x00,
    'I',0x00,
    'n',0x00,
    'c',0x00,
    '.',0x00
  };


#define PDS_LEN sizeof("EasyCOM_TWSI")*2
//-----PRODUCT(UNICODE) in String Descriptor-----//
code BYTE PRODUCT_DESCRIPTOR[]=
  { PDS_LEN,
    0x03,                                        // Descriptor Type
    'E',0x00,
    'a',0x00,
    's',0x00,
    'y',0x00,
    'C',0x00,
    'O',0x00,
    'M',0x00,
    '_',0x00,
    'T',0x00,
    'W',0x00,
    'S',0x00,
    'I',0x00
  };

#define SNS_LEN sizeof("621031")*2
//-----Serial Number in String Descriptor-----//
code BYTE SERIALNUMBER_DESCRIPTOR[]=
  { SNS_LEN,
    0x03,                                        // Descriptor Type
    '6',0x00,
    '2',0x00,
    '1',0x00,
    '0',0x00,
    '3',0x00,
    '1',0x00
  };